<!DOCTYPE html>
<html lang="en">
<head>
    <!--<meta charset="utf-8">-->

    <meta http-equiv="Content-type" content="text/html; charset=utf-8">
	<meta name="viewport" content="width=device-width,initial-scale=1">	
    <title>Datatable Editor</title>

	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css">
    <link href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css" rel="stylesheet" type="text/css">

	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
	
    <style>
        .tablelist_wrap {
            width: 80%; 
            margin: 2% auto;
        }
    </style>
	<?php 
		require_once '../db.php';
		include_once '../function.php';

		if($_POST['postAdd']):	
			$fromx = $_POST['fromx'];
			$tox = $_POST['tox'];
			$priorityx = $_POST['priorityx'];	

			$table = 'PDF_trans';
			$data = array(
				'fromx'	=> $fromx,
				'tox'	=> $tox,
				'priorityx'	=> $priorityx,
			);
			$result = insert_table($table,$data);

			//redirect after 5secs
			redirect();
		endif;
		
		if($_POST['postEdit'] && $_GET['id'] != '' ):
			$idx = $_GET['id'];
			$fromx = $_POST['fromx'];
			$tox = $_POST['tox'];
			$priorityx = $_POST['priorityx'];
			
			$table = 'PDF_trans';
			$data = array(
				'fromx'	=> $fromx,
				'tox'	=> $tox,
				'priorityx'	=> $priorityx,
			);
			$where = "WHERE id=".$idx;

			$result = update_table($table, $data, $where);
			
			//redirect after 5secs
			redirect();			
		endif;

		if( isset($_GET['action']) && $_GET['action']=='delete' && $_GET['id'] != '' ):			
			$idx = $_GET['id'];

			$table = 'PDF_trans';
			$where = " id = ".$idx;
			$result = delete_record($table, $where);	
			
			//redirect after 5secs
			redirect();		
		endif;

		function redirect() {
			$page = 'https://pdfai.mvmvm.com/Editor/datatable-editor.php';
			$sec = "2";
			header("Refresh: $sec; url=$page");
		}
	?>
</head>
<body>
	<div class="tablelist_wrap">
		<div class="mb-5">
			<a href="datatable-editor.php" class="me-2 h4 text-secondary">HOME</a> | <a href="?action=add" class="ms-2 h4 text-secondary">ADD</a>
		</div>

		<div class="container-fluid">		
			<div class="row">

				<?php if(isset($_GET['action']) && $_GET['action']=='add'): ?>
					<div class="add-section mb-5 py-3 px-3 border border-dark w-50 mx-auto">		
							<div class="col-md-12">
								<h4 class="text-center">ADD NEW</h4>
								<form action="?action=add" method="post">
									<div class="form-group">
										<input type="text" class="form-control" id="fromx" placeholder="From" name="fromx" required>
									</div>
									<div class="form-group">
										<input type="text" class="form-control" id="tox" placeholder="To" name="tox" required>
									</div>
									<div class="form-group">
										<input type="text" class="form-control" id="priorityx" placeholder="Priority" name="priorityx" required>
									</div>
									<button type="submit" class="btn btn-warning px-5" name="postAdd" value="1">ADD</button>
								</form>
								<?php echo $result;?>
							</div>
						</div>
				<?php endif; ?>	

				<?php if(isset($_GET['action']) && $_GET['action']=='edit'): ?>
					<?php 
						$from = "PDF_trans";
						$where = " id = ".$_GET['id'];
						$dataEdit = selectdatabyid($from, $where);
					?>
					<div class="edit-section mb-5 py-3 px-3 border border-dark w-50 mx-auto">		
							<div class="col-md-12">
								<h4 class="text-center">EDIT</h4>
								<form action="?action=edit&id=<?php echo $_GET['id'];?>" method="post">
									<div class="form-group">
										<input type="text" class="form-control" id="fromx" placeholder="From" name="fromx" value="<?php echo $dataEdit->fromx;?>" required>
									</div>
									<div class="form-group">
										<input type="text" class="form-control" id="tox" placeholder="To" name="tox" value="<?php echo $dataEdit->tox;?>" required>
									</div>
									<div class="form-group">
										<input type="text" class="form-control" id="priorityx" placeholder="Priority" name="priorityx" value="<?php echo $dataEdit->priorityx;?>" required>
									</div>
									<button type="submit" class="btn btn-warning px-5" name="postEdit" value="1">EDIT</button>
								</form>
								<?php echo $result;?>
							</div>
						</div>
				<?php endif; ?>	
			</div>
		</div>

	<?php if( $_GET['action'] == '' ): ?> 
		<table id="tablelist" class="display" cellspacing="0" width="100%">
			<thead>
				<tr>
					<th>ID</th>
					<th>From</th>
					<th>To</th>
					<th>Priority</th>
					<th width="18%">Date Created</th>
					<th></th>
				</tr>
			</thead>
			<tbody>
				<?php 
					$data = fetchtable("PDF_trans", " fromx != ''");
					if($data) {
						foreach($data as $row):
				?>
							<tr>
								<td><?php echo $row['id'];?></td>
								<td><?php echo $row['fromx'];?></td>
								<td><?php echo $row['tox'];?></td>
								<td><?php echo $row['priorityx'];?></td>
								<td><?php echo $row['date_created'];?></td>
								<td>
									<a href="?action=edit&id=<?php echo $row['id'];?>">Edit</a> | 
									<a href="?action=delete&id=<?php echo $row['id'];?>" onclick="return confirm('Are you sure you want to delete this data?');">Delete</a>
								</td>
							</tr>
				<?php
						endforeach;
					}else {
				?>
						<tr><td colspan="5">No data found.</td></tr>
				<?php
					}
				?>                    
            </tbody>
			
			<tfooter>
				<tr>
					<th>ID</th>
					<th>From</th>
					<th>To</th>
					<th>Priority</th>
					<th width="18%">Date Created</th>
					<th></th>
				</tr>
			</tfooter>	
		</table>
	<?php endif; ?>

	</div>
		
	<script type="text/javascript" src="https://code.jquery.com/jquery-3.5.1.js"></script>

	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
	<script type="text/javascript" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
	<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
	<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
	<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
	<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
	<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
	<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
	<script>
		$(document).ready(function () {
			$('#tablelist').DataTable(
            {
                  "lengthMenu": [[100, 250, 500, 1000, -1], [100, 250, 500, 1000, "All"]]
            }
            
            );
		});
	</script>
</body>
</html>