<?php
include_once 'db.php';
 
function isFileNameExist($file){

    $db = Database::getConnection();
    $sql = "Select * from pdf_data where file='" . $db->real_escape_string($file)."'";
    if ($result = $db->query($sql)) {
        if ($obj = $result->fetch_object()) {
            return $obj;
        }else{
            return "file not exist";
        }
    }

}

function delete_record($table,$where) {
	$db = Database::getConnection();	
    $sql = "DELETE FROM `".$table."` WHERE ".$where;
	//echo $sql;
	if ($result = $db->query($sql)) {
       return "data deleted";
    }
}

function update_table($table,$data,$where){

    $db = Database::getConnection();	
	$update_data = Database::create_update_data($data);
    $sql = "UPDATE `".$table."` SET ".$update_data." ". $where." LIMIT 1";
	//echo $sql;
	if ($result = $db->query($sql)) {
        return "data updated";
    }
}

function insert_table($table,$data){

    $db = Database::getConnection();
    $insert_data = Database::create_insert_data($data);
    $sql = "INSERT INTO `".$table."` (".$insert_data['keys'].") VALUES(". $insert_data['values'].")";
    //echo "<hr>";
    if ($result = $db->query($sql)) {
        return "data inserted <hr>";
    }
    
}

function fetchtable($from, $where){
    $db = Database::getConnection();

    $sql = "SELECT * FROM " . $from . " WHERE " . $where;
    if ($result = $db->query($sql)) {
        $num_rows = $result->num_rows;
    
        if($num_rows > 0){
            while($row = $result->fetch_assoc()){
                $data = array();
                foreach($row as $key => $value){
                    $data[$key] = $value;
                }	
                $array[] = $data;
            }
            return $array;
        }
    }
}

function selectdatabyid($from, $where){
    $db = Database::getConnection();
    
    $sql = "SELECT * FROM " . $from . " WHERE " . $where;
    
    if ($result = $db->query($sql)) {

        while ($obj = $result->fetch_object()) {
            return $obj;
        }
    }
}

function keycleanup($key) {
    $key=str_replace("*", "", $key);
    $key=trim($key);
    return $key; 
}




function income_numeric($str){

    function string_to_number($str) {
        $num = false;
        $str = strtolower($str);
        $multipliers = array(
            "h" => 100,
            "k"  => 1000,
            "m"  => 1000000,
            "mm"  => 1000000,
            "b"  => 1000000000,
            "t"  => 1000000000000,
            "thousand" => 1000,
            "million" => 1000000,
            "billion" => 1000000000,
            "trillion" => 1000000000000,
        );
        
        foreach ($multipliers as $word => $multiplier) {
            if (strpos($str, $word) !== false) {
                $num = floatval(str_replace($word, "", $str)) * $multiplier; //replace to floatval
                break;
            }
        }
        
        if (!$num) {
            $num = floatval($str);
        }
        
        return $num;
    }

    if(!is_numeric($str)){ 
        $str = str_replace("$", "", $str);
        $str = str_replace(",", "", $str);
        $str = str_replace(' ', '', $str);
        $str = str_replace('.00', '', $str); // remove the Cents. 
        $str = str_replace('.', '', $str); //  Take out any other periods.  
        if (str_contains($str, "-")) {
            list($start, $end) = explode("-", $str, 2);
            
            if((strlen($start) <= 3) && (preg_match('/[a-zA-Z]/', $start) === 0)){ 
                if (preg_match('/(\d+)-(\d+)([a-zA-Z]+)?/', $str, $matches)) { // the matches should be greater than 3
                    if(count($matches) > 3){ // check if there is a letter after the number
                        $letter = $matches[3];
                        $num = string_to_number($start. ' ' .$letter);
                        return $num;
                    }else{
                        $num = string_to_number($str);
                        return $num;
                    }
                }
            }else{ // if len are 3 above (5,000)
                $num = string_to_number($start);
                return $num;
            }
        }else{
            $num = string_to_number($str);
            return $num;
        }
        
    }else{
        return $str;
    }
}


function validateEMAIL($email) {
    $v = "/[a-zA-Z0-9_-.+]+@[a-zA-Z0-9-]+.[a-zA-Z]+/";
    return @(bool)preg_match($v, $email);
}


function capitalize(string $instr): string {

    // VALIDATE PASSED STRING
        if (!empty($instr)) {

            // SET INITIAL VARIABLES
                $instr                = str_replace('’', "'", strtolower($instr));
                $wordSplitters       = [' ', '-', "O'", "L'", "D'", 'St.', 'Mc','.'];
                $lowercaseExceptions = ['the', 'van', 'den', 'von', 'und', 'der', 'de', 'da', 'of', 'and', "l'", "d'"];
                $uppercaseExceptions = ['III', 'IV', 'VI', 'VII', 'VIII', 'IX','LLC'];
                //$isemail = validateEMAIL($instr);      
                $isemail = (filter_var($instr, FILTER_VALIDATE_EMAIL)!==false);

                if ($isemail)  {
                   return strtolower( $instr ); 
                    exit; 
                }
            // LOOP THROUGH WORD SPLITTERS

                foreach ($wordSplitters as $delimiter) {

                    // SET INITIAL LOOP VARIABLES

                        $words    = explode($delimiter, $instr);
                        $newWords = [];

                    // LOOP THROUGH WORDS AND DECIDE CASE | DECIDE CASE OF WORD SPLITTER / DELIMITER

                        foreach ($words as $word) {

                            if (in_array(strtoupper($word), $uppercaseExceptions)) {
                                $word = strtoupper($word);
                            } else if (!in_array($word, $lowercaseExceptions)) {
                                $word = ucfirst($word);
                            }
                            $newWords[] = $word;
                        }

                        if (in_array(strtolower($delimiter), $lowercaseExceptions)) {
                            $delimiter = strtolower($delimiter);
                        }

                    //  REBUILD NAME
                        $instr = implode($delimiter, $newWords);
                }
        }

    // RETURN STRING
       return $instr;

}



function zipToState($zipcode)
{
  /* 000 to 999 */
  $zip_by_state = [
    '--', '--', '--', '--', '--', 'NY', 'PR', 'PR', 'VI', 'PR', 'MA', 'MA', 'MA', 
    'MA', 'MA', 'MA', 'MA', 'MA', 'MA', 'MA', 'MA', 'MA', 'MA', 'MA', 'MA', 'MA', 
    'MA', 'MA', 'RI', 'RI', 'NH', 'NH', 'NH', 'NH', 'NH', 'NH', 'NH', 'NH', 'NH', 
    'ME', 'ME', 'ME', 'ME', 'ME', 'ME', 'ME', 'ME', 'ME', 'ME', 'ME', 'VT', 'VT', 
    'VT', 'VT', 'VT', 'MA', 'VT', 'VT', 'VT', 'VT', 'CT', 'CT', 'CT', 'CT', 'CT', 
    'CT', 'CT', 'CT', 'CT', 'CT', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 
    'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'NJ', 'AE', 
    'AE', 'AE', 'AE', 'AE', 'AE', 'AE', 'AE', 'AE', '--', 'NY', 'NY', 'NY', 'NY', 
    'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 
    'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 
    'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 
    'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'NY', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 
    'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 
    'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 
    'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', 'PA', '--', 'PA', 'PA', 
    'PA', 'PA', 'DE', 'DE', 'DE', 'DC', 'VA', 'DC', 'DC', 'DC', 'DC', 'MD', 'MD', 
    'MD', 'MD', 'MD', 'MD', 'MD', '--', 'MD', 'MD', 'MD', 'MD', 'MD', 'MD', 'VA', 
    'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 
    'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 'VA', 
    'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 
    'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', 'WV', '--', 'NC', 'NC', 'NC', 
    'NC', 'NC', 'NC', 'NC', 'NC', 'NC', 'NC', 'NC', 'NC', 'NC', 'NC', 'NC', 'NC', 
    'NC', 'NC', 'NC', 'NC', 'SC', 'SC', 'SC', 'SC', 'SC', 'SC', 'SC', 'SC', 'SC', 
    'SC', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 
    'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'GA', 'FL', 'FL', 'FL', 'FL', 'FL', 
    'FL', 'FL', 'FL', 'FL', 'FL', 'FL', 'FL', 'FL', 'FL', 'FL', 'FL', 'FL', 'FL', 
    'FL', 'FL', 'AA', 'FL', 'FL', '--', 'FL', '--', 'FL', 'FL', '--', 'FL', 'AL', 
    'AL', 'AL', '--', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 
    'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'TN', 'TN', 'TN', 'TN', 'TN', 'TN', 'TN', 
    'TN', 'TN', 'TN', 'TN', 'TN', 'TN', 'TN', 'TN', 'TN', 'MS', 'MS', 'MS', 'MS', 
    'MS', 'MS', 'MS', 'MS', 'MS', 'MS', 'MS', 'MS', 'GA', '--', 'KY', 'KY', 'KY', 
    'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 
    'KY', 'KY', 'KY', '--', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', 'KY', '--', 
    '--', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 
    'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 'OH', 
    'OH', 'OH', 'OH', 'OH', '--', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 
    'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'IN', 'MI', 
    'MI', 'MI', 'MI', 'MI', 'MI', 'MI', 'MI', 'MI', 'MI', 'MI', 'MI', 'MI', 'MI', 
    'MI', 'MI', 'MI', 'MI', 'MI', 'MI', 'IA', 'IA', 'IA', 'IA', 'IA', 'IA', 'IA', 
    'IA', 'IA', '--', 'IA', 'IA', 'IA', 'IA', 'IA', 'IA', 'IA', '--', '--', '--', 
    'IA', 'IA', 'IA', 'IA', 'IA', 'IA', 'IA', 'IA', 'IA', '--', 'WI', 'WI', 'WI', 
    '--', 'WI', 'WI', '--', 'WI', 'WI', 'WI', 'WI', 'WI', 'WI', 'WI', 'WI', 'WI', 
    'WI', 'WI', 'WI', 'WI', 'MN', 'MN', '--', 'MN', 'MN', 'MN', 'MN', 'MN', 'MN', 
    'MN', 'MN', 'MN', 'MN', 'MN', 'MN', 'MN', 'MN', 'MN', '--', 'DC', 'SD', 'SD', 
    'SD', 'SD', 'SD', 'SD', 'SD', 'SD', '--', '--', 'ND', 'ND', 'ND', 'ND', 'ND', 
    'ND', 'ND', 'ND', 'ND', '--', 'MT', 'MT', 'MT', 'MT', 'MT', 'MT', 'MT', 'MT', 
    'MT', 'MT', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 
    'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'IL', '--', 'IL', 'IL', 
    'IL', 'IL', 'IL', 'IL', 'IL', 'IL', 'MO', 'MO', '--', 'MO', 'MO', 'MO', 'MO', 
    'MO', 'MO', 'MO', 'MO', 'MO', '--', '--', 'MO', 'MO', 'MO', 'MO', 'MO', '--', 
    'MO', 'MO', 'MO', 'MO', 'MO', 'MO', 'MO', 'MO', 'MO', '--', 'KS', 'KS', 'KS', 
    '--', 'KS', 'KS', 'KS', 'KS', 'KS', 'KS', 'KS', 'KS', 'KS', 'KS', 'KS', 'KS', 
    'KS', 'KS', 'KS', 'KS', 'NE', 'NE', '--', 'NE', 'NE', 'NE', 'NE', 'NE', 'NE', 
    'NE', 'NE', 'NE', 'NE', 'NE', '--', '--', '--', '--', '--', '--', 'LA', 'LA', 
    '--', 'LA', 'LA', 'LA', 'LA', 'LA', 'LA', '--', 'LA', 'LA', 'LA', 'LA', 'LA', 
    '--', 'AR', 'AR', 'AR', 'AR', 'AR', 'AR', 'AR', 'AR', 'AR', 'AR', 'AR', 'AR', 
    'AR', 'AR', 'OK', 'OK', '--', 'TX', 'OK', 'OK', 'OK', 'OK', 'OK', 'OK', 'OK', 
    'OK', '--', 'OK', 'OK', 'OK', 'OK', 'OK', 'OK', 'OK', 'TX', 'TX', 'TX', 'TX', 
    'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 
    'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 
    'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 
    'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'TX', 'CO', 'CO', 'CO', 'CO', 'CO', 'CO', 
    'CO', 'CO', 'CO', 'CO', 'CO', 'CO', 'CO', 'CO', 'CO', 'CO', 'CO', '--', '--', 
    '--', 'WY', 'WY', 'WY', 'WY', 'WY', 'WY', 'WY', 'WY', 'WY', 'WY', 'WY', 'WY', 
    'ID', 'ID', 'ID', 'ID', 'ID', 'ID', 'ID', '--', 'UT', 'UT', '--', 'UT', 'UT', 
    'UT', 'UT', 'UT', '--', '--', 'AZ', 'AZ', 'AZ', 'AZ', '--', 'AZ', 'AZ', 'AZ', 
    '--', 'AZ', 'AZ', '--', '--', 'AZ', 'AZ', 'AZ', '--', '--', '--', '--', 'NM', 
    'NM', '--', 'NM', 'NM', 'NM', '--', 'NM', 'NM', 'NM', 'NM', 'NM', 'NM', 'NM', 
    'NM', 'NM', '--', '--', '--', '--', 'NV', 'NV', '--', 'NV', 'NV', 'NV', '--', 
    'NV', 'NV', '--', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', '--', 
    'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 
    'CA', 'CA', 'CA', 'CA', 'CA', 'CA', '--', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 
    'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 
    'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 'CA', 
    'AP', 'AP', 'AP', 'AP', 'AP', 'HI', 'HI', 'GU', 'OR', 'OR', 'OR', 'OR', 'OR', 
    'OR', 'OR', 'OR', 'OR', 'OR', 'WA', 'WA', 'WA', 'WA', 'WA', 'WA', 'WA', '--', 
    'WA', 'WA', 'WA', 'WA', 'WA', 'WA', 'WA', 'AK', 'AK', 'AK', 'AK', 'AK'
  ];

  $prefix = substr($zipcode, 0, 3);
  $index = intval($prefix); /* converts prefix to integer */
  return $zip_by_state[$index];
}



function findcity($zipcode) {

    $zipcode = str_pad($zipcode , 5, "0", STR_PAD_LEFT);  // make sure zipcode is 5 digits

    $db = Database::getConnection();
        $sql = "SELECT  CityName as city,  StateAbbr as st FROM zip  WHERE  ZIPCode = '$zipcode' order by CityType limit 1  ";
    
    if ($result = $db->query($sql)) {

        while ($obj = $result->fetch_object()) {
            return $obj;
        }
    }
    return false;
}






//$startDate = "Nov-12-1982";
//$startDate = "1989-08-01";
//$startDate = "1/1/5115";
//$startDate = "6262020";
//$startDate = "October 1";
//$startDate = "August/01/2022";
//$startDate = "10 1991";
//$startDate = "May 1992";
//$startDate = "7/1993";
//$startDate = "09-03-1999";
//$startDate = "June 6 2006";
//$startDate = "06/13/12";
//$startDate = "2014/04/01";
//$startDate = "2015-07-27";
//$startDate = "3/2017";
//$startDate = "January / 2022";
//$startDate = "January 01";

// new test case
//$startDate = "2004";
//$startDate = "1/25/1964 0:00";
//$startDate = "9-Mar-21";
//$startDate = "Feb-20";
//$startDate = "Apr-18";
//$startDate = "9-Oct-19";
//$startDate = "2 Years"; 
//$startDate = "August 2018"; 
//$startDate = "4 19 1976"; 
//$startDate = "3.8.1975"; 
//$startDate = "29/09/1962";
//$startDate = "August / 2019"; 

// convertDate($startDate);
function convertDate($startDate)
{
    $defaultYear = "2021";
    $startDateorg = $startDate; 

    if (strlen(strtotime($startDate)) == 11) {
        $startDate =  $startDateorg;//  "Invalid date";
    } else
    
    if($date = DateTime::createFromFormat('m/d/Y', $startDate) && strstr($startDate, '/', true) < 13 && strlen(substr(strrchr($startDate, '/'), 1)) == 4){
        $startDate = $startDate;
    }else
    
    if($date = DateTime::createFromFormat('m / d / Y', $startDate)){
        $startDate = $date->format('m/d/Y');
    }else

    if ($date = DateTime::createFromFormat('n/j/y', $startDate)) { //Month/day/year
        $startDate = $date->format('m/d/Y');
    }else

    if ($date = DateTime::createFromFormat('d/m/Y', $startDate)) { //Month/day/year
        $startDate = $date->format('m/d/Y');
    }else

    if (strpos(strtolower($startDate), "years") !== false) {
        $startDate = date('m/d/Y', strtotime("- $startDate"));
    }else

    if (preg_match('/^[^\/\s]{7}$/', $startDate)) { //complete date w/o spaces / or -
        $startDate = substr($startDate, 0, 1) . '/' . substr($startDate, 1, 2) . '/' . substr($startDate, 3);
    }else

    if (strlen($startDate) == 4) { // Fix start date. if year 
        $startDate = '1/1/' . $startDate;
    }else

    if ($date = DateTime::createFromFormat('d Y', $startDate)) {
        $startDate = $date->format('m/01/Y');
    }else

    if ($date = DateTime::createFromFormat('m.d.Y', $startDate)) {
        $startDate = $date->format('m/d/Y');
    }else

    // if(strlen(strtotime($startDate)) == 9){ 
//     $startDate = date("m/d/Y", strtotime($startDate));
// }

    if ($date = DateTime::createFromFormat('m/d/Y h:i', $startDate)) { //month-day-year
        $startDate = $date->format('m/d/Y');
    }else

    if ($date = DateTime::createFromFormat('m-d', $startDate)) { //month-day-year
        $startDate = $date->format('m/d/') . $defaultYear;
    }else

    if ($date = DateTime::createFromFormat('M-y', $startDate)) { //Apr-18
        $startDate = $date->format('m/01/Y');
    }else

    if ($date = DateTime::createFromFormat('d-M-y', $startDate)) { //month-day-year
        $startDate = $date->format('m/d/Y');
    }else

    if ($date = DateTime::createFromFormat('m-d-Y', $startDate)) { //month-day-year
        $startDate = $date->format('m/d/Y');
    }else

    if ($date = DateTime::createFromFormat('m d Y', $startDate)) {
        $startDate = $date->format('m/d/Y');
    }else

    if ($date = DateTime::createFromFormat('m/d/yy', $startDate)) { //month day year
        $startDate = $date->format('m/d/Y');
    }else

    if ($date = DateTime::createFromFormat('m/Y', $startDate)) { //month/year
        $startDate = $date->format('m/01/Y');
    }else

    if ($date = DateTime::createFromFormat('F d', $startDate)) { //month / year
        $startDate = $date->format('m/d/') . $defaultYear;
    }else

    if ($date = DateTime::createFromFormat('F Y', $startDate)) { //month / year
        $startDate = $date->format('m/01/Y');
    }else

    if ($date = DateTime::createFromFormat('F / Y', $startDate)) { //month / year
        $startDate = $date->format('m/01/Y');
    }else

    if ($date = DateTime::createFromFormat('F yyyy', $startDate)) { //Month year
        $startDate = $date->format('m/01/Y');
    }else

    if ($date = DateTime::createFromFormat('F d yyyy', $startDate)) { //month day year
        $startDate = $date->format('m/d/Y');
    }else

    if ($date = DateTime::createFromFormat('F d', $startDate)) { //Month and day only
        $startDate = $date->format('m/d') . '/' . $defaultYear;
    }else

    if ($date = DateTime::createFromFormat('F d Y', $startDate)) { //month day year
        $startDate = $date->format('m/d/Y');
    }else

    if ($date = DateTime::createFromFormat('F dd Y', $startDate)) { //month day year
        $startDate = $date->format('m/d/Y');
    }else

    if ($date = DateTime::createFromFormat('F/d/Y', $startDate)) { //month/day/year
        $startDate = $date->format('m/d/Y');
    }else

    if ($date = DateTime::createFromFormat('Y/m/d', $startDate)) { //YYYY/mm/dd
        $startDate = $date->format('m/d/Y');
    }else

    if ($date = DateTime::createFromFormat('Y-m-d', $startDate)) { //YYYY-mm-dd
        $startDate = $date->format('m/d/Y');
    }else

    if ($date = DateTime::createFromFormat('Y-n-j', $startDate)) { //YYYY-m-d
        $startDate = $date->format('m/d/Y');
    }else

    if ($date = DateTime::createFromFormat('Y-m-d', $startDate)) { //year-month-day
        $startDate = $date->format('m/d/Y');
    }else
    if ($date = DateTime::createFromFormat('m-d-Y', $startDate)) { //Month Day Year 2 
        $startDate = $date->format('m/d/Y');
    }else

    if ($date = DateTime::createFromFormat('M-d-Y', $startDate)) { //Month-day-year
        $startDate = $date->format('m/d/Y');
    }else

    if ($date = DateTime::createFromFormat('m Y', $startDate)) { //month year
        $startDate = $date->format('m/01/Y');
    }else

    if ($date = DateTime::createFromFormat('m/Y', $startDate)) { //month/year
        $startDate = $date->format('m/01/Y');
    }else

    if ($date = DateTime::createFromFormat('M/d/Y', $startDate)) { //Month/day/year
        $startDate = $date->format('m/d/Y');
    }else

    if ($startDate != '') { // Fix start date. 
//       $fileRecord->{'startDate'}=date('m/d/Y',strtotime( $fileRecord->{'startDate'}));
    }else

    if (strlen($startDate) == 7) { // MM/YYYY
        $startDate = str_replace('/', '/1/', $startDate); // add a 1 in middle of /  
    }else
    if (strlen($startDate) == 5) { // MM/YY
        $startDate = str_replace('/', '/1/', $startDate); // add a 1 in middle of /  
        $startDate = date('m/d/Y', strtotime($startDate));
    }
  //   echo $startDate;
    return $startDate;
}
